import pandas as pd
from datetime import datetime, timedelta
from matplotlib import pyplot as plt
from matplotlib import dates as mpl_dates

plt.style.use("seaborn")

dates = [
    datetime(2019,5,24),
    datetime(2019,5,25),
    datetime(2019,5,26),
    datetime(2019,5,27),
    datetime(2019,5,28),
    datetime(2019,5,29),
    datetime(2019,5,30)
]

y = [0,1,3,4,6,5,7]

plt.plot_date(dates, y, linestyle='solid')

# get current figure gcf()
# autoformat dates
plt.gcf().autofmt_xdate()

# date formatting - datetime.strftime or mpl_dates
date_format = mpl_dates.DateFormatter('%d. %b %Y')
plt.gca().xaxis.set_major_formatter(date_format)

plt.tight_layout()
plt.show()

